
-- erreurs

USE BD_Air_France;

IF OBJECT_ID ('dbo.T_Pilote_pil','U') IS NOT NULL
    DROP TABLE dbo.T_Pilote_pil;
GO

IF OBJECT_ID ('dbo.T_compagnie_cmp','U') IS NOT NULL
    DROP TABLE dbo.T_compagnie_cmp;
GO

CREATE TABLE T_compagnie_cmp
(cmp_comp     VARCHAR(4) PRIMARY KEY, 
 cmp_effectif INT, 
 cmp_ville    VARCHAR(30), 
 cmp_nom      VARCHAR(30));
GO

CREATE TABLE T_Pilote_pil
(pil_brevet VARCHAR(6),
 pil_nom    VARCHAR(20)  CONSTRAINT nn_nom NOT NULL, 
 pil_nbHVol DECIMAL(7,2) CONSTRAINT ck_h_vol CHECK (pil_nbhvol >= 1500),
 pil_mail VARCHAR(50),
 cmp_comp VARCHAR(4),
 pil_embauche DATE       CONSTRAINT dk_embauche DEFAULT (GETDATE()),
 CONSTRAINT un_pil_nom UNIQUE (pil_nom),
 CONSTRAINT pk_Pilote PRIMARY KEY(pil_brevet),
 CONSTRAINT fk_pil_cmp FOREIGN KEY (cmp_comp) REFERENCES T_compagnie_cmp);
GO

CREATE UNIQUE INDEX idx_pil_mail ON T_Pilote_pil(pil_mail);
GO

INSERT INTO T_compagnie_cmp VALUES ('AF', 5600, 'Roissy', 'Air France');
INSERT INTO T_compagnie_cmp VALUES ('SING', 1200, 'Singapore', 'SING AL');
INSERT INTO T_compagnie_cmp VALUES ('CAST', 50, 'Blagnac', 'Air Castanet');

INSERT INTO T_Pilote_pil 
   VALUES ('PL-1', 'Giaconne', 2450,'gia@free.fr','AF','20120405');
INSERT INTO T_Pilote_pil 
   VALUES ('PL-2', 'Bardon', 1900,NULL,'AF','20110506');
INSERT INTO T_Pilote_pil 
   VALUES ('PL-3', 'Mejers', 2500,NULL,'SING',NULL);
INSERT INTO T_Pilote_pil 
   VALUES ('PL-4', 'Lhospice', 5500,NULL ,'CAST',NULL);
INSERT INTO T_Pilote_pil 
   VALUES ('PL-5', 'Calac', 5400,NULL ,'AF','20120507');
INSERT INTO T_Pilote_pil 
   VALUES ('PL-6', 'Cogne', 2500,NULL ,'SING',NULL);

-- 318, 7-30
 
CREATE PROCEDURE P_ajoute_pil
(@pil_brevet VARCHAR(6), @cmp_comp VARCHAR(4),
 @pil_nom  VARCHAR(20),  @pil_nbHVol DECIMAL(7,2),
 @pil_mail VARCHAR(50),
 @retour_err SMALLINT OUTPUT, @retour_lib VARCHAR(500) OUTPUT) AS
BEGIN
 BEGIN TRY
    INSERT INTO T_Pilote_pil
                  (pil_brevet,pil_nom,pil_mail,pil_nbHVol,cmp_comp)
         VALUES (@pil_brevet,@pil_nom,@pil_mail,@pil_nbHVol,@cmp_comp);
 --  'pilote insr';
 END TRY
 BEGIN CATCH
 -- pour toute erreur
  SET @retour_err = ERROR_NUMBER();
  SET @retour_lib = ERROR_MESSAGE();
 END CATCH;
END;
GO

-- 
  --> NOT NULL          / 515
  --> PRIMARY KEY       / 2627
  --> contrainte UNIQUE / 2627
  --> index UNIQUE      / 2601
  --> CHECK             / 547
  --> FOREIGN KEY       / 547

DECLARE @err SMALLINT;
DECLARE @lib VARCHAR(500);
-- EXEC P_ajoute_pil  'PL-1','AB',NULL,1000,'gia@free.fr',@err OUTPUT,@lib OUTPUT;
-- EXEC P_ajoute_pil  'PL-1','AB','Giaconne',1000,'gia@free.fr',@err OUTPUT,@lib OUTPUT;
-- EXEC P_ajoute_pil  'PL-10','AB','Giaconne',1000,'gia@free.fr',@err OUTPUT,@lib OUTPUT;
-- EXEC P_ajoute_pil  'PL-10','AB','Bon',1000,'gia@free.fr',@err OUTPUT,@lib OUTPUT;
-- EXEC P_ajoute_pil  'PL-10','AB','Bon',1600,'bon@free.fr',@err OUTPUT,@lib OUTPUT;
 EXEC P_ajoute_pil  'PL-10','AF','Bon',1600,'gia@free.fr',@err OUTPUT,@lib OUTPUT;
SET @lib =
 CASE
   WHEN @err = 515  THEN 'Problme de valeur non NULL'
   WHEN @err = 2627 THEN 'Problme d''unicit (contrainte)'
   WHEN @err = 2601 THEN 'Problme d''unicit (index)'
   WHEN @err = 547  THEN 'Problme de contrainte (FK/CHECK)'
   ELSE @lib        
 END
PRINT @lib;

-- 319, 7-32

DROP PROCEDURE P_ajoute_pil;
GO 

CREATE PROCEDURE P_ajoute_pil
(@pil_brevet VARCHAR(6), @cmp_comp VARCHAR(4),
 @pil_nom  VARCHAR(20),  @pil_nbHVol DECIMAL(7,2),
 @pil_mail VARCHAR(50),
 @retour_err INT OUTPUT, @retour_lib VARCHAR(500) OUTPUT) AS
BEGIN
 DECLARE @res BIT = 0;
 BEGIN TRY
    SELECT @res=COUNT(cmp_comp) FROM T_compagnie_cmp 
                                WHERE cmp_comp=@cmp_comp;
    IF @res=0
       THROW 50001,'Code compagnie incorrect',1;
    INSERT INTO T_Pilote_pil
                  (pil_brevet,pil_nom,pil_mail,pil_nbHVol,cmp_comp)
         VALUES (@pil_brevet,@pil_nom,@pil_mail,@pil_nbHVol,@cmp_comp);
 --  'pilote insr';
 END TRY
 BEGIN CATCH
  SET @retour_err = error_number();
  SET @retour_lib = error_message();
  SET @retour_lib =
   CASE
     WHEN @retour_err = 515   THEN 'Problme de valeur non NULL'
     WHEN @retour_err = 2627  THEN 'Problme d''unicit (contrainte)'
     WHEN @retour_err = 2601  THEN 'Problme d''unicit (index)'
     WHEN @retour_err = 547   THEN 'Problme de contrainte CHECK'
     ELSE @retour_lib 
 END
 END CATCH;
END;
GO

DECLARE @err INT;
DECLARE @lib VARCHAR(500);

EXEC P_ajoute_pil 'PL-1','AB',NULL,1000,
                  'gia@free.fr',@err OUTPUT,@lib OUTPUT;

EXEC P_ajoute_pil 'PL-1','AF',NULL,1000,
                  'gia@free.fr',@err OUTPUT,@lib OUTPUT;

PRINT @err;
PRINT @lib;

-- 

DROP PROCEDURE P_ajoute_pil;
GO 

IF OBJECT_ID ('dbo.T_Pilote_pil','U') IS NOT NULL
    DROP TABLE dbo.T_Pilote_pil;
GO

IF OBJECT_ID ('dbo.T_compagnie_cmp','U') IS NOT NULL
    DROP TABLE dbo.T_compagnie_cmp;
GO